<?php
/*
Plugin Name: Custom Field Redirect
Plugin URI: http://www.nathanrice.net/plugins/custom-field-redirect/
Description: This plugin will do a 301 redirect on any page where you set the "redirect" key in a custom field.  The value you set will be the URL to where the plugin will redirect you.
Version: 0.1
Author: Nathan Rice
Author URI: http://www.nathanrice.net/

License: This plugin is licensed under GPL.  
*/

//set the options
$key = 'redirect';
$status = 301;

//Hook the link rewrite function into the page_link filter
//This part replaces the page URL, wherever it is outputted, with our custom URL
add_filter('page_link','custom_field_page_link',10,2);
function custom_field_page_link($link,$id) {
	//globalize vars
	global $key;
	
	$custom_page_url = get_post_meta($id, $key, true);
	if(!empty($custom_page_url)) $link = $custom_page_url;
	return $link;
}

//Hook the redirect function into the template_redirect action
//This part actually does the redirect, if necessary
add_action('template_redirect','custom_field_redirect');
function custom_field_redirect() {
	//globalize vars
	global $wp_query, $key, $status;
	
	$redirect = get_post_meta($wp_query->post->ID, $key, true);
	if(!empty($redirect) && is_singular()) {
		//And do the redirect.
		wp_redirect($redirect, $status);
	}
}
?>